Floor = class()

function Floor:created(yLine, grassSize)
    -- you can accept and set parameters here
    self.entity.y = -gameWorld.camera:get(camera).orthoSize / 2 - 0.5
    self.manager = scene.main:findEntity("Manager"):get(GameManager)
    self.entity.body2d:box(scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT),1)
    self.entity.collisionBegan2d = function()
        if not self.manager.touchGround then
            local instance = sound.play(asset.sfx_die)
            table.insert(allSounds, instance)
        end
        self.manager.touchGround = true
    end
    self.colors = {
        strokeC = color(114, 161, 72),
    fillC = color(143, 181, 102),
    dirt = color(175, 154, 127)}
    
    self.yLine = yLine
    self.grassSize = grassSize
end


function Floor:update()
    self.entity.collider2d.size = vec2(scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT), self.yLine)
    self.entity.y = -((gameWorld.camera:get(camera).orthoSize / 2.)) + (self.yLine/2)
end

function Floor:draw()
    style.push().fill(self.colors.dirt).rectMode(CORNER).sortOrder(-7)
    rect(-(scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT) /2.), math.abs(self.entity.y) - (scene.main.camera:get(camera).orthoSize/2.), scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT) + 1., self.yLine - self.grassSize)
    style.pop()
    
    style.push().fill(self.colors.fillC).rectMode(CORNER).sortOrder(-7).strokeWidth(0.3 * scene.main.pixelsPerUnit).stroke(self.colors.strokeC)
        lineWidth = style.strokeWidth()
    rect(-(scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT) /2.) -0.5, (self.yLine/2.) - self.grassSize, scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT) + 1., self.grassSize - (lineWidth /2.) / scene.main.pixelsPerUnit)
    style.pop()
end

